///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

namespace MonoScan
{
	using System;
	using System.Xml;

	public class Configuration
	{
		private Configuration()
		{
		}

		public static string Path
		{
			get { return System.Windows.Forms.Application.StartupPath + "\\MonoScan.xml"; }
		}

		public static XmlNodeList FindXmlNodes(XmlNode baseXmlNode, string path, params object[] args)
		{
			if (baseXmlNode == null)
				return null;

			if (args != null && args.Length != 0)
				path = string.Format(path, args);
			
			return baseXmlNode.SelectNodes(path);
		}

		public static XmlNode FindXmlNode(XmlNode baseXmlNode, string path, params object[] args)
		{
			if (baseXmlNode == null) 
				return null;

			if (args != null && args.Length != 0)
				path = string.Format(path, args);
			
			return baseXmlNode.SelectSingleNode(path);
		}

		public static XmlNode GetXmlNode(XmlNode baseXmlNode, string path, params object[] args)
		{
			if (args != null && args.Length != 0)
				path = string.Format(path, args);

			if (baseXmlNode == null)
				throw new Exception(string.Format("Couldn't find XML node '{0}'", path));
			
			XmlNode xmlNode = baseXmlNode.SelectSingleNode(path);

			if (xmlNode == null)
				throw new Exception(string.Format("Couldn't find XML node '{0}'", path));

			return xmlNode;
		}

		public static string FindXmlNodeAttribute(XmlNode xmlNode, string attributeName)
		{
			if (xmlNode == null)
				return null;

			XmlAttribute xmlAttribute = xmlNode.Attributes[attributeName];

			if (xmlAttribute == null)
				return null;

			return xmlAttribute.Value;
		}

		public static string GetXmlNodeAttribute(XmlNode xmlNode, string attributeName)
		{
			if (xmlNode == null)
				throw new Exception(string.Format("Couldn't find XML attribute '{0}'", attributeName));

			XmlAttribute xmlAttribute = xmlNode.Attributes[attributeName];

			if (xmlAttribute == null)
				throw new Exception(string.Format("Couldn't find XML attribute '{0}'", attributeName));

			return xmlAttribute.Value;
		}

		public static string GetXmlNodeValue(XmlNode xmlNode)
		{
			if (xmlNode == null)
				throw new Exception("Couldn't find XML node value");

			return xmlNode.InnerText;
		}

		public static XmlNode CreateChildXmlNode(XmlNode parentXmlNode, string nodeName)
		{
			XmlNode xmlNode = parentXmlNode.SelectSingleNode(nodeName);

			if (xmlNode == null)
			{
				xmlNode = parentXmlNode.OwnerDocument.CreateElement(nodeName);
				parentXmlNode.AppendChild(xmlNode);
			}
			else
				xmlNode.RemoveAll();

			return xmlNode;
		}

		public static XmlNode CreateChildXmlNodes(XmlNode parentXmlNode, string nodeName)
		{
			XmlNode xmlNode = parentXmlNode.OwnerDocument.CreateElement(nodeName);
			parentXmlNode.AppendChild(xmlNode);

			return xmlNode;
		}

		public static void CreateXmlNodeAttribute(XmlNode xmlNode, string attributeName, string attributeValue)
		{
			XmlAttribute xmlAttribute = xmlNode.Attributes[attributeName];

			if (xmlAttribute == null)
			{
				xmlAttribute = xmlNode.OwnerDocument.CreateAttribute(attributeName);
				xmlAttribute.Value = attributeValue;
				xmlNode.Attributes.SetNamedItem(xmlAttribute);
			}
			else
				xmlAttribute.Value = attributeValue;
		}

		public static void CreateXmlNodeValue(XmlNode xmlNode, string value)
		{
			xmlNode.InnerText = value;
		}
	}
}